/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.HitResult;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Set<WoodType> CUSTOM_TEXTURE_WOOD_TYPES = Set.of(WoodType.f_61833_, WoodType.f_61832_, WoodType.f_61836_, WoodType.f_61835_, WoodType.f_61834_, WoodType.f_61830_, WoodType.f_61831_, WoodType.f_61837_);

    protected WoodStorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void addNameWoodAndTintData(ItemStack stack, BlockGetter level, BlockPos pos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)((Object)be)));
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked()) {
                wbe.setPacked(false);
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                CompoundTag storageContents = be.m_187482_();
                if (!storageContents.m_128456_()) {
                    ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                    NBTHelper.setUniqueId((ItemStack)stack, (String)"uuid", (UUID)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
            }
        }
    }

    private void addNameWoodAndTintData(ItemStack stack, WoodStorageBlockEntity wbe) {
        Item item = stack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor > -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) > -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        wbe.getCustomName().ifPresent(arg_0 -> ((ItemStack)stack).m_41714_(arg_0));
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        CUSTOM_TEXTURE_WOOD_TYPES.forEach(woodType -> items.add((Object)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), woodType)));
        for (DyeColor color : DyeColor.values()) {
            ItemStack storageStack = new ItemStack((ItemLike)this);
            Item item = storageStack.m_41720_();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
            }
            items.add((Object)storageStack);
        }
        ItemStack storageStack = new ItemStack((ItemLike)this);
        Item item = storageStack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])DyeColor.YELLOW.m_41068_()));
            tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])DyeColor.LIME.m_41068_()));
        }
        items.add((Object)storageStack);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNameWoodAndTintData(stack, world, pos);
        return stack;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.m_142466_(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            WoodStorageBlockItem.getWoodType(stack).ifPresent(be::setWoodType);
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(be.getStorageWrapper()::setMainColor);
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(be.getStorageWrapper()::setAccentColor);
            be.tryToAddToController();
        });
    }

    protected boolean tryPackBlock(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        if (stackInHand.m_41720_() == ModItems.PACKING_TAPE.get()) {
            if (!player.m_7500_()) {
                stackInHand.m_41721_(stackInHand.m_41773_() + 1);
                if (stackInHand.m_41773_() >= stackInHand.m_41776_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
            b.setPacked(true);
            b.removeFromController();
            WorldHelper.notifyBlockUpdate((BlockEntity)b);
            return true;
        }
        return false;
    }
}

